/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.curseofpandora.content.sets.angle;

import dev.xkmc.curseofpandora.content.complex.BaseTickingToken;
import dev.xkmc.curseofpandora.content.complex.IAttackListenerToken;
import dev.xkmc.curseofpandora.content.complex.ITokenProviderItem;
import dev.xkmc.curseofpandora.content.reality.CurseOfTensionItem;
import dev.xkmc.curseofpandora.event.ClientSpellText;
import dev.xkmc.curseofpandora.event.ItemEffectHandlers;
import dev.xkmc.curseofpandora.init.data.CoPConfig;
import dev.xkmc.curseofpandora.init.data.CoPLangData;
import dev.xkmc.curseofpandora.init.registrate.CoPAttrs;
import dev.xkmc.curseofpandora.init.registrate.CoPItems;
import dev.xkmc.l2damagetracker.contents.attack.AttackCache;
import dev.xkmc.l2damagetracker.contents.attack.DamageModifier;
import dev.xkmc.l2library.capability.conditionals.ConditionalData;
import dev.xkmc.l2serial.serialization.SerialClass;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class AngelicPunishment
extends ITokenProviderItem<Data> {
    private static AngelicPunishment item() {
        return (AngelicPunishment)((Object)CoPItems.ANGELIC_PUNISHMENT.get());
    }

    public static boolean check(Player player, int reality) {
        if (((ConditionalData)ConditionalData.HOLDER.get(player)).getData(AngelicPunishment.item().getKey()) != null) {
            return true;
        }
        return player.m_9236_().m_45527_(player.m_20183_()) && player.m_21133_((Attribute)CoPAttrs.REALITY.get()) >= (double)reality;
    }

    public static int getCoolDown() {
        return (Integer)CoPConfig.COMMON.angelic.angelicPunishmentCoolDown.get();
    }

    public static int getIndexReq() {
        return (Integer)CoPConfig.COMMON.angelic.angelicPunishmentRealityIndex.get();
    }

    public static double getDamageBase() {
        return (Double)CoPConfig.COMMON.angelic.angelicPunishmentDamageBase.get();
    }

    public AngelicPunishment(Item.Properties properties) {
        super(properties, Data::new);
    }

    @Override
    public void tick(Player player) {
        if (player.m_21133_((Attribute)CoPAttrs.REALITY.get()) >= (double)AngelicPunishment.getIndexReq()) {
            super.tick(player);
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        boolean pass = ClientSpellText.getReality(level) >= AngelicPunishment.getIndexReq();
        list.add((Component)CoPLangData.IDS.REALITY_INDEX.get(AngelicPunishment.getIndexReq()).m_130940_(pass ? ChatFormatting.YELLOW : ChatFormatting.GRAY));
        list.add((Component)CoPLangData.Angelic.PUNISHMENT_1.get(new Object[0]).m_130940_(pass ? ChatFormatting.GOLD : ChatFormatting.DARK_GRAY));
        list.add((Component)CoPLangData.Angelic.PUNISHMENT_2.get(Math.round(AngelicPunishment.getDamageBase() * 100.0), Math.round((double)AngelicPunishment.getCoolDown() / 20.0)).m_130940_(pass ? ChatFormatting.DARK_AQUA : ChatFormatting.DARK_GRAY));
    }

    @SerialClass
    public static class Data
    extends BaseTickingToken
    implements IAttackListenerToken {
        @SerialClass.SerialField
        private int cooldown;

        @Override
        protected void removeImpl(Player player) {
        }

        @Override
        protected void tickImpl(Player player) {
            if (this.cooldown > 0) {
                --this.cooldown;
            }
        }

        @Override
        public void onPlayerDamageTarget(Player player, AttackCache cache) {
            ConditionalData cond = (ConditionalData)ConditionalData.HOLDER.get(player);
            CurseOfTensionItem.Ticker tension = (CurseOfTensionItem.Ticker)cond.getData(((CurseOfTensionItem)((Object)CoPItems.CURSE_OF_TENSION.get())).getKey());
            if (tension != null && tension.isTerrorized(cache.getAttackTarget())) {
                return;
            }
            if (AngelicPunishment.check(player, AngelicPunishment.getIndexReq())) {
                cache.addDealtModifier(DamageModifier.nonlinearMiddle((int)71, e -> this.mapVal(e, cache.getAttackTarget())));
            }
        }

        private float mapVal(float damage, LivingEntity target) {
            float min = (float)((double)target.m_21223_() * AngelicPunishment.getDamageBase());
            if (damage < min && this.cooldown == 0) {
                this.cooldown = AngelicPunishment.getCoolDown();
                ItemEffectHandlers.ANGELIC_PUNISHMENT.trigger(target);
                return min;
            }
            return damage;
        }
    }
}

